﻿//////////////////////////////////////////////
// ExecutionResult.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkMemory
#include <NilkinsMemory/Containers/String.h>

/// Class ------------------------------------

namespace nkScripts
{
	enum class EXECUTION_FAILURE_TYPE
	{
		NO_ERROR = 0,
		UNKNOWN,
		INTERPRETER_UNKNOWN,
		INTERPRETER_TYPE_MISMATCH,
		BYTECODE_NOT_READY,
		RUNTIME,
		MEMORY_ALLOCATION
	} ;

	struct ExecutionResult final
	{
		// If failure
		nkMemory::String _failureMessage ;
		EXECUTION_FAILURE_TYPE _failureType = EXECUTION_FAILURE_TYPE::NO_ERROR ;

		// Successful load or not
		bool _success = true ;
	} ;
}